' -----------------------------------------------------------
' Program for Micromite to drive 8x8 LED array with an expanding
' star pattern using the MAX7219 SPI LED driver.
' Written by Jim Rowe.
' Last revision 1/12/2016 at 3.05 pm
' 
' Note that Micromite's SPI interface uses these pins:
' SPI Function        Micromite pin
' MOSI (SPI out)      Pin 3
' MISO (SPI in)       Pin 14
' SCK (SPI clock)     Pin 25
' SS/CS-bar/LOAD      Pin 22
' ----------------------------------------------------------

OPTION AUTORUN ON
OPTION EXPLICIT

DIM AS INTEGER index               ' counter
DIM AS INTEGER outData, inData     ' variables

Dim AS INTEGER RegData(5) ' array to store MAX7219 register setup codes
RegData(0) = &H0C01   ' sets the SHUTDOWN reg for normal operation
RegData(1) = &H0900   ' sets the DECODE mode reg for no decoding
RegData(2) = &H0A07   ' sets the INTENSITY reg for 8/16 intensity
RegData(3) = &H0B07   ' sets the SCAN LIMIT reg for all 8 digits
RegData(4) = &H0F00   ' sets the DISPLAY-TEST reg for all 8 digits

PAUSE 200        ' wait 200ms for LCD to stabilise after poweruplist
SPI OPEN 5000000, 0, 16 ' open SPI (speed, mode, bits)
SETPIN 22, DOUT     ' declare pin 22 as a digital output (LOAD)
PIN(22) = 0         ' and initialise it to low
InitMAX7219         ' then go initialise the MAX7219

' main program loop starts here
DO
  ' first blank whole array
  outData = &H0100  ' sends a column of 0s to digit 0
  SendIt
  outData = &H0200  ' and digit 1
  SendIt
  outData = &H0300  ' and digit 2
  SendIt
  outData = &H0400  ' and digit 3
  SendIt
  outData = &H0500  ' and digit 4
  Sendit
  outData = &H0600  ' and digit 5
  SendIt
  outData = &H0700  ' and digit 6
  SendIt
  outData = &H0800  ' and digit 7
  SendIt
  Pause 1000        ' then pause briefly
  
  outData = &H0418  ' now send first 4 dots of star
  SendIt 
  outData = &H0518
  SendIt
  Pause 250         ' then pause briefly for visibility
  
  outData = &H0324  ' before sending next 4 dots
  SendIt
  outData = &H0624 
  SendIt
  Pause 250         ' then pause briefly for visibility
  
  outData = &H0242  ' before sending next 4 dots
  SendIt
  outData = &H0742 
  SendIt
  PAUSE 250         ' then pause briefly for visibility
  
  outData = &H033C  ' then add 4 extra dots
  SendIt
  outData = &H043E
  SendIt
  outData = &H057C
  SendIt
  outData = &H063C  
  SendIt
  Pause 250         ' then pause briefly for visibility
    
  outData = &H0181  ' now add the final outer 8 dots
  SendIt
  outData = &H0252
  SendIt
  outData = &H074A
  SendIt
  outData = &H0881
  SendIt
  Pause 3000        ' now pause for visibility
  
LOOP

END ' end of main part of program, subs follow 
' -----------------------------------------------------------------
'  subroutine to initialise the MAX7219
SUB InitMAX7219
    For index = 0 To 4
      outData = RegData(index)
      SendIt
      PAUSE 50    ' pause to let MAX7219 settle down
    Next
END SUB
' -----------------------------------------------------------------
' subroutine to send a 16-bit word to the MAX7219
SUB SendIt
  inData = SPI(outData)   ' sends the data word out
  PIN(22) = 1             ' pulse pin22 high to load it
  PIN(22) = 0             ' then low again to reset
    
END SUB
' -----------------------------------------------------------------
